/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8290;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.MessageDestination;
import ibm.nways.jdm.NavigationBrowser;
import ibm.nways.jdm.NavigationBrowserEventListener;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.NavigationFolder;
import ibm.nways.jdm.NavigationItem;
import ibm.nways.jdm.NavigationPoint;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.browser.Browser;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.NotSupported;
import ibm.nways.jdm.common.Timeout;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmContext;
import ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel;
import ibm.nways.jdm.eui.BoxDownMsg;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8290.eui.ConfigurationGroup;
import ibm.nways.jdm8290.eui.FaultGroup;
import ibm.nways.mib2.eui.SystemGroup;
import ibm.nways.ras.RAS;
import ibm.nways.telnet.TelnetContext;
import ibm.nways.web.WebContext;
import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.io.Serializable;
import java.util.ResourceBundle;

public class Jdm8290
extends JdmBrowser {
    private static final int RASID = 19;
    private static final int RASSUB = 23;
    NavigationFolder root;
    GenModel model;
    private ResourceBundle jdm8290Bundle;
    private NavigationBrowser tree;
    private boolean deviceIsUp;
    private SnmpContextModel contextModel;

    public String getModelTypeName() {
        return "ibm.nways.jdm8290.model.Jdm8290";
    }

    protected synchronized SnmpContextModel getContextModel() {
        SnmpContextModel snmpContextModel = null;
        Jdm8290 jdm8290 = this;
        synchronized (jdm8290) {
            if (this.contextModel == null) {
                try {
                    this.contextModel = (SnmpContextModel)this.model.getComponent("_ContextInfo");
                }
                catch (Exception exception) {
                    this.contextModel = null;
                    exception.printStackTrace();
                }
            }
            snmpContextModel = this.contextModel;
        }
        return snmpContextModel;
    }

    public GraphicPanel getDeviceGraphicPanel() {
        GraphicPanel graphicPanel = null;
        try {
            Image image;
            this.displayMsg(this.jdm8290Bundle.getString("startGraphic"));
            SnmpContextModel snmpContextModel = this.getContextModel();
            String string = snmpContextModel.getSystemIdentifier();
            GraphicContainer graphicContainer = new GraphicContainer();
            if (string != null) {
                image = this.imageFrom((Object)this, string);
                GraphicImage graphicImage = new GraphicImage(image, new Point(19, 0), 1);
                graphicContainer.add((GraphicComponent)graphicImage);
            }
            image = new GraphicHelp((BrowserApplet)this, new Point(0, 5), new HelpRef((Object)this));
            graphicContainer.add((GraphicComponent)image);
            graphicPanel = new GraphicPanel((GraphicHandler)this, (Component)graphicContainer);
            this.displayMsg(this.jdm8290Bundle.getString("endGraphic"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return graphicPanel;
    }

    private void getInitialDeviceInfo() {
        try {
            ModelInfo modelInfo = this.model.getInfo("Config");
            Serializable serializable = modelInfo.get("Config.SysUpTime");
            if (serializable instanceof Timeout || serializable instanceof NotSupported) {
                if (RAS.isEnabled(19, 23)) {
                    RAS.trace(19, 23, (Object)this, "getInitialDeviceInfo", "Can't talk to the Device " + serializable.toString());
                }
                this.deviceIsUp = false;
                new BoxDownMsg(this.getFrame(), this.jdm8290Bundle.getString("jdm8290"));
                return;
            }
            this.deviceIsUp = true;
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 23, (Object)this, "getInitialDeviceInfo", exception);
            this.deviceIsUp = false;
            return;
        }
    }

    protected NavigationPoint getNavTreeRoot() {
        this.jdm8290Bundle = ResourceBundle.getBundle("ibm.nways.jdm8290.Resources");
        this.displayMsg(this.jdm8290Bundle.getString("askServer"));
        this.model = (GenModel)this.getModel();
        this.displayMsg(this.jdm8290Bundle.getString("serverDone"));
        this.getInitialDeviceInfo();
        this.displayMsg(this.jdm8290Bundle.getString("createNavigationTree"));
        this.root = new NavigationFolder(this.jdm8290Bundle.getString("8290"));
        return this.root;
    }

    protected void getRestOfNavTree() {
        this.tree = this.getNavigationBrowser();
        NavigationContext navigationContext = this.root.getNavContext();
        navigationContext.put((Object)"TREE", (Object)this.tree);
        if (this.deviceIsUp) {
            try {
                GenModel genModel = (GenModel)this.model.getComponent("Configuration");
                ConfigurationGroup configurationGroup = new ConfigurationGroup((JdmBrowser)this, genModel);
                configurationGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)configurationGroup);
                this.root.add((NavigationPoint)configurationGroup);
                NavigationFolder navigationFolder = new NavigationFolder(this.jdm8290Bundle.getString("system"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
                configurationGroup.add((NavigationPoint)navigationFolder);
                this.buildGeneral(navigationFolder);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.buildFault(this.root);
        } else {
            NavigationFolder navigationFolder = new NavigationFolder(this.jdm8290Bundle.getString("configuration"));
            this.root.add((NavigationPoint)navigationFolder);
            NavigationFolder navigationFolder2 = new NavigationFolder(this.jdm8290Bundle.getString("system"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder.add((NavigationPoint)navigationFolder2);
            NavigationFolder navigationFolder3 = new NavigationFolder(this.jdm8290Bundle.getString("general"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
            navigationFolder2.add((NavigationPoint)navigationFolder3);
            SnmpContextModel snmpContextModel = this.getContextModel();
            navigationFolder3.add((NavigationPoint)new NavigationItem(this.jdm8290Bundle.getString("snmpConfig"), new NavigationDestination("ibm.nways.jdm.modelgen.SnmpConfigPanel", (RemoteModel)snmpContextModel), "SnmpConfig"));
            navigationFolder3.add((NavigationPoint)new NavigationItem(this.jdm8290Bundle.getString("perfConfig"), new NavigationDestination("ibm.nways.analysis.dpManager.Admin.DpAdminDestinationPanel", (RemoteModel)snmpContextModel), "PerfConfig"));
            NavigationItem navigationItem = new NavigationItem(this.jdm8290Bundle.getString("communications"), (NavigationDestination)new MessageDestination(this.jdm8290Bundle.getString("notConfigured")));
            navigationFolder.add((NavigationPoint)navigationItem);
            this.root.add((NavigationPoint)new NavigationItem(this.jdm8290Bundle.getString("fault"), (NavigationDestination)new MessageDestination(this.jdm8290Bundle.getString("notConfigured"))));
        }
        this.buildTools(this.root);
        this.displayMsg(this.jdm8290Bundle.getString("initDone"));
    }

    private void buildGeneral(NavigationFolder navigationFolder) {
        try {
            GenModel genModel = (GenModel)this.model.getComponent("System");
            if (genModel != null) {
                SystemGroup systemGroup = new SystemGroup((JdmBrowser)this, genModel);
                systemGroup.setIsInitiallyExpanded(false);
                this.tree.addEventListener((NavigationBrowserEventListener)systemGroup);
                navigationFolder.add((NavigationPoint)systemGroup);
                SnmpContextModel snmpContextModel = this.getContextModel();
                systemGroup.add((NavigationPoint)new NavigationItem(this.jdm8290Bundle.getString("snmpConfig"), new NavigationDestination("ibm.nways.jdm.modelgen.SnmpConfigPanel", (RemoteModel)snmpContextModel), "SnmpConfig"));
                systemGroup.add((NavigationPoint)new NavigationItem(this.jdm8290Bundle.getString("perfConfig"), new NavigationDestination("ibm.nways.analysis.dpManager.Admin.DpAdminDestinationPanel", (RemoteModel)snmpContextModel), "PerfConfig"));
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void buildFault(NavigationFolder navigationFolder) {
        try {
            GenModel genModel = (GenModel)this.model.getComponent("Traps");
            FaultGroup faultGroup = new FaultGroup((JdmBrowser)this, genModel);
            faultGroup.setIsInitiallyExpanded(false);
            this.tree.addEventListener((NavigationBrowserEventListener)faultGroup);
            navigationFolder.add((NavigationPoint)faultGroup);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    private void buildTools(NavigationFolder navigationFolder) {
        NavigationFolder navigationFolder2 = new NavigationFolder(this.jdm8290Bundle.getString("tools"), new NavigationDestination("ibm.nways.jdm.NilDestination", null));
        navigationFolder.add((NavigationPoint)navigationFolder2);
        try {
            SnmpContextModel snmpContextModel = this.getContextModel();
            ModelInfo modelInfo = snmpContextModel.getConfig();
            String string = modelInfo.get("Config.Address").toString();
            ResourceBundle resourceBundle = ResourceBundle.getBundle("ibm.nways.telnet.TelnetPanelResources");
            TelnetContext telnetContext = new TelnetContext(string);
            NavigationItem navigationItem = new NavigationItem(resourceBundle.getString("TelnetPanelTitle"), new NavigationDestination("ibm.nways.telnet.TelnetPanel", null), "Telnet");
            NavigationContext navigationContext = navigationItem.getNavContext();
            navigationContext.put((Object)"telnetContext", (Object)telnetContext);
            navigationFolder2.add((NavigationPoint)navigationItem);
            Browser browser = new Browser("MIB Browser", (JdmBrowser)this, snmpContextModel);
            NavigationBrowser navigationBrowser = this.getNavigationBrowser();
            navigationBrowser.addEventListener((NavigationBrowserEventListener)browser);
            navigationFolder2.add((NavigationPoint)browser.getRootFolder());
            ResourceBundle resourceBundle2 = ResourceBundle.getBundle("ibm.nways.web.Resources");
            WebContext webContext = new WebContext(string);
            webContext.support_and_device();
            NavigationItem navigationItem2 = new NavigationItem(resourceBundle2.getString("weblaunch"), new NavigationDestination("ibm.nways.web.WebBrowserPanel", null), "WebBrowser");
            navigationContext = navigationItem2.getNavContext();
            navigationContext.put((Object)"webContext", (Object)webContext);
            navigationFolder2.add((NavigationPoint)navigationItem2);
            if (this.getIsApplication()) {
                AnalyzerJdmContext analyzerJdmContext = new AnalyzerJdmContext(string, this.getServerPortNumber());
                NavigationItem navigationItem3 = new NavigationItem(AnalyzerJdmPanel.getTitle(), new NavigationDestination("ibm.nways.jdm.database.analyzer.AnalyzerJdmPanel", null), "Analyzer");
                navigationContext = navigationItem3.getNavContext();
                navigationContext.put((Object)"analyzerJdmContext", (Object)analyzerJdmContext);
                navigationFolder2.add((NavigationPoint)navigationItem3);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

